<?php

include 'db.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    $username = $_POST['username'];
    $out_all = $_POST['out_all'];

    $query = "SELECT * FROM users WHERE username = :username";
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':username', $username);
    $stmt->execute();
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
		
    if ($user) {
        $active_devices = json_decode($user['active_devices'], true);

        if ($out_all === "true") {
            foreach ($active_devices as $key => $device) {
                $active_devices[$key]['mode'] = "false";
            }
            $updated_active_devices = json_encode($active_devices);
            $query = "UPDATE users SET active_devices = :active_devices WHERE username = :username";
            $stmt = $pdo->prepare($query);
            $stmt->bindParam(':active_devices', $updated_active_devices);
            $stmt->bindParam(':username', $username);
            $stmt->execute(); 
            echo 'all_device_kick';
        } else {		
            $unique_id = $_POST['unique_id'];
            foreach ($active_devices as $key => $device) {
                if ($device['unique_id'] == $unique_id) {
                    $active_devices[$key]['mode'] = "false";
                    $updated_active_devices = json_encode($active_devices);
                    $query = "UPDATE users SET active_devices = :active_devices WHERE username = :username";
                    $stmt = $pdo->prepare($query);
                    $stmt->bindParam(':active_devices', $updated_active_devices);
                    $stmt->bindParam(':username', $username);
                    $stmt->execute();
                echo 'true_kick';
                    break;
                }
            }
        }	
    } else {
        echo 'user_not_found';
    }
}
