<?php
include 'db.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['username'];
    $name = $_POST['name'];
    $image = $_POST['image'];
    $new_name = $_POST['new_name'];

    $query = "SELECT symbol FROM users WHERE username = :username";
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':username', $username);
    $stmt->execute();
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (empty($user['symbol']) || $user['symbol'] === "null") {
        $new_symbol = array(array('name' => $new_name, 'image' => $image));
        $new_symbol_json = json_encode($new_symbol);

        $query = "UPDATE users SET symbol = :new_symbol WHERE username = :username";
        $stmt = $pdo->prepare($query);
        $stmt->bindParam(':new_symbol', $new_symbol_json);
        $stmt->bindParam(':username', $username);
        $stmt->execute();

        echo 'symbol_record_created';
    } else {
        $symbol_json = json_decode($user['symbol'], true);
        $name_exists = false;

        foreach ($symbol_json as $key => &$entry) {
            if ($entry['name'] === $name) {
                if ($new_name === "delete") {
                    unset($symbol_json[$key]);
                    echo 'index_deleted';
                } else {
                    $entry['image'] = $image;
                    if ($name !== $new_name) {
                        $entry['name'] = $new_name;
                    }
                    $name_exists = true;
                    echo 'symbol_updated';
                }
                break;
            }
        }

        if (!$name_exists && $new_name !== "delete") {
            $new_entry = array('name' => $new_name, 'image' => $image);
            $symbol_json[] = $new_entry;

            echo 'new_index_created';
        }

        $updated_symbol = json_encode(array_values($symbol_json));
        $query = "UPDATE users SET symbol = :updated_symbol WHERE username = :username";
        $stmt = $pdo->prepare($query);
        $stmt->bindParam(':updated_symbol', $updated_symbol);
        $stmt->bindParam(':username', $username);
        $stmt->execute();
    }
}

